///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef ClientThread_Cpp
#define ClientThread_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/HashKey.H"
#include "../../SharedSource/Common.H"

#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE ghEvent_ClientThread = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::Start_ClientThread(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::Start_ClientThread.\n");
    #endif

	ghEvent_ClientThread = CreateEvent(NULL, TRUE, FALSE, "Client_Thread_Function");

	memset(&CTI, 0, sizeof(CTI));
    CTI.Client = iClient;

    if((hcClient_Thread_Handle[iClient] = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)Client_Thread_Function, (LPVOID) this, 0, (LPDWORD) &dwcClient_Thread_ID[iClient])) == NULL)
    {
        FatalError(__FILE__, __LINE__, "CreateThread failed.");
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

    if(WaitForSingleObject(ghEvent_ClientThread, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

	//The thread was started, trigger the event.
	Events.OnBeginClientThread(this, iClient);

	CloseHandle(ghEvent_ClientThread);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::WaitOnClientThreadToExit(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::WaitOnClientThreadToExit.\n");
    #endif

	DWORD dwExitCode = 0;

    int iWaitCount = 0;

    while(GetExitCodeThread(hcClient_Thread_Handle[iClient], &dwExitCode))
    {
        if(dwExitCode != STILL_ACTIVE || iWaitCount == 500)
        {
            if(iWaitCount == 500)
            {
				WriteLogEx(icClientID[iClient], "Possible thread dead-lock. Thread will be terminated.", EVENT_ERROR);
                TerminateThread(hcClient_Thread_Handle[iClient], 1);
            }

            //The thread was stopped, trigger the event.
			Events.OnEndClientThread(this, iClient);

			CloseHandle(hcClient_Thread_Handle[iClient]);
            dwcClient_Thread_ID[iClient] = 0;
            return true;
        }

        iWaitCount++;
        Sleep(1);
    }

	//The thread was stopped, trigger the event.
	Events.OnEndClientThread(this, iClient);

    FatalError(__FILE__, __LINE__, "GetExitCodeThread failed.");
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread_Function(LPVOID pvThread)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> Client_Thread_Function.\n");
    #endif

    //---------------------(Initialize Thread [Begin])----------
   	CSockSrvr *pSockSrvr = ((CSockSrvr *)pvThread);

	int iClient = ((CSockSrvr *)pvThread)->CTI.Client;

	SetEvent(ghEvent_ClientThread);
    //---------------------(Initialize Thread [END])----------

	char sRecvBuf[RECVBUFSZ + 1];
	char sRawHash[1024];
	int iRecvBufSz = 0;
	int iWait = 0;

	//--------------------------------------------------------------------------------------------------------
	/*(This BELOW helps to point out Denial-of-Service attacks) (BEGIN) */
	if(!GenerateKey(gdwRawHashLen, (GetTickCount()+iClient), GKUPPER_AZ|GKLOWER_AZ|GKNUMBERS|GKNONREPETITION, sRawHash))
	{
		WriteLogEx(pSockSrvr->icClientID[iClient], "Client_Thread_Function failed to generate a key.", EVENT_ERROR);
		pSockSrvr->bcDisconnect[iClient] = true;
		return 0;
	}

	//Using the sRecvBuf and iRecvBufSz to hold the data to be sent.
	//	This is not standard, Just saving stack space.
	//Send a plain text random string to the client.
	//	The first data received from the client is expected to be the
	//		hash of this key.
	iRecvBufSz = AppendDataToCmd("::RawHash->", sRawHash, gdwRawHashLen, sRecvBuf);
	pSockSrvr->SetNextSendDataEx(iClient, sRecvBuf, iRecvBufSz);

	HashKey((const unsigned char *)sRawHash, (unsigned char *)sRawHash, gdwRawHashLen, gdwRawHashLen);

	while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		//Receive the client's data.
		if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
		{
			sRawHash[gdwRawHashLen] = '\0';
			sRecvBuf[iRecvBufSz] = '\0';

			//Check to see if the dat recevied is the string hash.
			if(strcmp(sRawHash, sRecvBuf) != 0)
			{
				WriteLogEx(pSockSrvr->icClientID[iClient], "Client returned incorrect hash value. Possible DOS attack.", EVENT_WARN);
				pSockSrvr->bcDisconnect[iClient] = true;
				return 0;
			}
			break;
		}

		iWait++;

		//If the client takes too long to respond to the
		//	request for the key hash, disconnect them.
		if(iWait == gdwHashTimeoutMS)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Client did not respond. Possible DOS attack.", EVENT_WARN);
			pSockSrvr->bcDisconnect[iClient] = true;
			return 0;				
		}

		Sleep(1);
	}
	/*(The ABOVE code helps to point out Denial-of-Service attacks) (END) */
	//--------------------------------------------------------------------------------------------------------

	pSockSrvr->SetNextSendData(iClient, "::RequestAuthString");

	while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
		{
			//sRecvBuf[iRecvBufSz] = '\0';
			//printf("GotSize[%d] : %d\n", iClient, iRecvBufSz);
			//printf("GotData[%d]:%s\n", iClient, sRecvBuf);

			if(CCI[iClient].bIsAuthenticated == false)
			{
				int iAuthResult = PerformHandShake(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iAuthResult == AUTH_FAILED || iAuthResult == AUTH_ERROR)
				{
					WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed.", EVENT_ERROR);
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iAuthResult == AUTH_SUCCESS){

					CCI[iClient].bIsAuthenticated = true;

					//If were using compression, et the client know what algorithm to use.
					if(_strcmpi(gsCompressionMethod, "None") != 0)
					{
						sprintf_s(sRecvBuf, sizeof(sRecvBuf), "::CompressionMethod->%s", gsCompressionMethod);
						pSockSrvr->SetNextSendData(iClient, sRecvBuf);

						sprintf_s(sRecvBuf, sizeof(sRecvBuf), "::CompressionLevel->%d", gdwCompressionLevel);
						pSockSrvr->SetNextSendData(iClient, sRecvBuf);
					}
					else{
						strcpy_s(sRecvBuf, sizeof(sRecvBuf), "::CompressionMethod->None");
						pSockSrvr->SetNextSendData(iClient, sRecvBuf);

						WriteLogEx(pSockSrvr->icClientID[iClient], "Compression is disabled. This process will overwork the network.", EVENT_WARN);
					}

					//Send the first synchronization command to the client.
					//	We will either be telling the client to send us all of the data "::BeginInit"
					//		or to only send the transactional data "::BeginReplication->Transactions"
					if(CCI[iClient].bRequestInit)
					{
						char sInit[100];
						sprintf_s(sInit, sizeof(sInit), "::BeginInit->%d", CCI[iClient].iInitStep);
						pSockSrvr->SetNextSendData(iClient, sInit);
					}
					else {
						pSockSrvr->SetNextSendData(iClient, "::BeginReplication->Transactions");
					}
				}
				else if(iAuthResult == AUTH_OK){
					//The authentication process is still in process, all is well.
				}
			}
			else{
				int iCmdResult = ProcessCommand(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iCmdResult == CMD_ERROR)
				{
					WriteLogEx(pSockSrvr->icClientID[iClient], "Process command returned with an error.", EVENT_ERROR);
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_DONE) {
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_OK) {
					//All is well.
				}
			}
		}
		else Sleep(CLIENTTHREAD_MS_WAIT);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

